#include <iostream>
#include <vector>

using namespace std;

typedef long long ll;
typedef long double ld;

#define sz(a) (int)a.size()
#define all(a) (a).begin(), (a).end()
#define ff first
#define sc second
#define f(i, l, r) for (int i = (l); i < (r); ++i)
#define int long long
#define pb push_back
#define coe cout<<"yes\n"

const double EPS = 1e-6;

struct pt {
    double x, y;
    pt() = default;
    pt(double x_, double y_) {
        x=x_;y=y_;
    }
};

vector<double> getc(pt &a, pt &b) {
    double A = a.y - b.y;
    double B = b.x - a.x;
    double C = a.x * b.y - a.y * b.x;
    return {A, B, C};
}

bool parallel(vector<double> &L1, vector<double> &L2) {
    return (L1[0] * L2[1] == L1[1] * L2[0]);
}

pt peres(vector<double> &L1, vector<double> &L2) {
    double y = (L2[2] * L1[0] - L1[2] * L2[0]) / (L1[1] * L2[0] - L2[1] * L1[0]);
    double x = (L2[2] * L1[1] - L1[2] * L2[1]) / (L1[0] * L2[1] - L1[1] * L2[0]);
    return pt(x,y);
}

bool inseg(pt &a, pt &b, pt &c) {
    return (min(a.x, b.x) <= c.x + EPS && c.x <= max(a.x, b.x) + EPS && min(a.y,b.y)<=c.y+EPS&&c.y<=max(a.y,b.y)+EPS);
}

struct DSU {
    int n;
    vector<int> p, r, V, E;
    DSU() = default;
    DSU(int n_) {
        n = n_;
        p.assign(n, 0);
        V.assign(n, 0);
        E.assign(n, 0);
        r.assign(n, 0);
        f(i,0,n)p[i]=i;
    }

    int find(int v) {
        if (p[v] == v) return v;
        int res = find(p[v]);
        p[v] = res;
        return res;
    }

    void merge(int a, int b) {
        a = find(a);
        b = find(b);
        if (a == b) return;
        if(r[a] < r[b])swap(a,b);
        p[b] = a;
        V[a]+=V[b];
        E[a]+=E[b];
        if(r[a]==r[b])r[a]++;
    }
};

void solve() {
    int n; cin >> n;
    vector<pair<pt, pt>> segs(n);
    vector<vector<double>> lns(n);

    int V = 0, E = 0;

    DSU D(n);

    f (i, 0, n) {
        double x1, y1, x2, y2;cin>>x1>>y1>>x2>>y2;
        pt A(x1,y1),B(x2,y2);
        auto res = getc(A, B);
        D.V[i] += 2;
        D.E[i]++;
        bool wsa = false, wsb = false;
        f (j, 0, i) {
            bool nw=false;
            if ((abs(segs[j].ff.x-A.x)==0&&abs(segs[j].ff.y-A.y)==0)||(abs(segs[j].sc.x-A.x)==0&&abs(segs[j].sc.y-A.y)==0)){
                D.merge(j, i);
                wsa = true;
                nw=true;
            }
            if ((abs(segs[j].ff.x-B.x)==0&&abs(segs[j].ff.y-B.y)==0)||(abs(segs[j].sc.x-B.x)==0&&abs(segs[j].sc.y-B.y)==0)){
                D.merge(j, i);
                wsb = true;
                nw=true;
            }
            if(nw)continue;


            if (!parallel(lns[j], res)) {
                auto result = peres(lns[j], res);
                if (inseg(segs[j].ff, segs[j].sc, result) && inseg(A, B, result)) {
                    D.merge(j, i);

                    bool v1 = false, v2 = false;
                    if ((abs(result.x - A.x) < EPS && abs(result.y - A.y) < EPS) ||
                        (abs(result.x - B.x) < EPS && abs(result.y - B.y) < EPS)) {
                        v1 = true;
                    }

                    if ((abs(result.x - segs[j].ff.x) < EPS && abs(result.y - segs[j].ff.y) < EPS) ||
                        (abs(result.x - segs[j].sc.x) < EPS && abs(result.y - segs[j].sc.y) < EPS)) {
                        v2 = true;
                    }
                    int noww = D.find(i);
                    if (!v1 && !v2) {
                        D.V[noww]++;
                        D.E[noww] += 2;
                    } else if (!v2) {
                        D.E[noww]++;
                    } else if (!v1) {
                        D.E[noww]++;
                    }
                }
            }
        }
        int noww = D.find(i);
        if(wsa){D.V[noww]--;}
        if(wsb){D.V[noww]--;}
        segs[i] = {A, B};
        lns[i] = res;

    }

    vector<int> used(n, 0);
    int cntu = 0, cntgr = 0;
    f (i, 0, n) {
        int indd = D.find(i);
        if (!used[indd]) {
            used[indd] = 1;
            cntu++;
            cntgr += D.E[indd] + 2 - D.V[indd];
        }
    }

    cout<<cntgr - (cntu-1)<<'\n';
}

signed main() {
    ios_base::sync_with_stdio(false);
    cout.tie(nullptr);
    cin.tie(nullptr);

    int tt = 1; cin >> tt;
    while (tt--) {
        solve();
    }
}